/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.org.quartz.impl.jdbcjobstore;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.TimeZone;
import net.creeperhost.ftbbackups.org.quartz.CronScheduleBuilder;
import net.creeperhost.ftbbackups.org.quartz.CronTrigger;
import net.creeperhost.ftbbackups.org.quartz.JobDetail;
import net.creeperhost.ftbbackups.org.quartz.TriggerKey;
import net.creeperhost.ftbbackups.org.quartz.impl.jdbcjobstore.StdJDBCConstants;
import net.creeperhost.ftbbackups.org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate;
import net.creeperhost.ftbbackups.org.quartz.impl.jdbcjobstore.Util;
import net.creeperhost.ftbbackups.org.quartz.impl.triggers.CronTriggerImpl;
import net.creeperhost.ftbbackups.org.quartz.spi.OperableTrigger;

public class CronTriggerPersistenceDelegate
implements TriggerPersistenceDelegate,
StdJDBCConstants {
    protected String tablePrefix;
    protected String schedNameLiteral;

    public void initialize(String tablePrefix, String schedName) {
        this.tablePrefix = tablePrefix;
        this.schedNameLiteral = "'" + schedName + "'";
    }

    public String getHandledTriggerTypeDiscriminator() {
        return "CRON";
    }

    public boolean canHandleTriggerType(OperableTrigger trigger) {
        return trigger instanceof CronTriggerImpl && !((CronTriggerImpl)trigger).hasAdditionalProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteExtendedTriggerProperties(Connection conn, TriggerKey triggerKey) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(Util.rtp("DELETE FROM {0}CRON_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
            ps.setString(1, triggerKey.getName());
            ps.setString(2, triggerKey.getGroup());
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeStatement(ps);
            throw throwable;
        }
        Util.closeStatement(ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertExtendedTriggerProperties(Connection conn, OperableTrigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int n;
        CronTrigger cronTrigger = (CronTrigger)((Object)trigger);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(Util.rtp("INSERT INTO {0}CRON_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID)  VALUES({1}, ?, ?, ?, ?)", this.tablePrefix, this.schedNameLiteral));
            ps.setString(1, trigger.getKey().getName());
            ps.setString(2, trigger.getKey().getGroup());
            ps.setString(3, cronTrigger.getCronExpression());
            ps.setString(4, cronTrigger.getTimeZone().getID());
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeStatement(ps);
            throw throwable;
        }
        Util.closeStatement(ps);
        return n;
    }

    public TriggerPersistenceDelegate.TriggerPropertyBundle loadExtendedTriggerProperties(Connection conn, TriggerKey triggerKey) throws SQLException {
        block6: {
            TriggerPersistenceDelegate.TriggerPropertyBundle triggerPropertyBundle;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(Util.rtp("SELECT * FROM {0}CRON_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
                ps.setString(1, triggerKey.getName());
                ps.setString(2, triggerKey.getGroup());
                rs = ps.executeQuery();
                if (!rs.next()) break block6;
                String cronExpr = rs.getString("CRON_EXPRESSION");
                String timeZoneId = rs.getString("TIME_ZONE_ID");
                CronScheduleBuilder cb = null;
                try {
                    cb = CronScheduleBuilder.cronSchedule(cronExpr);
                }
                catch (ParseException neverHappens) {
                    // empty catch block
                }
                if (timeZoneId != null) {
                    cb.inTimeZone(TimeZone.getTimeZone(timeZoneId));
                }
                triggerPropertyBundle = new TriggerPersistenceDelegate.TriggerPropertyBundle(cb, null, null);
            }
            catch (Throwable throwable) {
                Util.closeResultSet(rs);
                Util.closeStatement(ps);
                throw throwable;
            }
            Util.closeResultSet(rs);
            Util.closeStatement(ps);
            return triggerPropertyBundle;
        }
        throw new IllegalStateException("No record found for selection of Trigger with key: '" + triggerKey + "' and statement: " + Util.rtp("SELECT * FROM {0}CRON_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateExtendedTriggerProperties(Connection conn, OperableTrigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int n;
        CronTrigger cronTrigger = (CronTrigger)((Object)trigger);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(Util.rtp("UPDATE {0}CRON_TRIGGERS SET CRON_EXPRESSION = ?, TIME_ZONE_ID = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
            ps.setString(1, cronTrigger.getCronExpression());
            ps.setString(2, cronTrigger.getTimeZone().getID());
            ps.setString(3, trigger.getKey().getName());
            ps.setString(4, trigger.getKey().getGroup());
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeStatement(ps);
            throw throwable;
        }
        Util.closeStatement(ps);
        return n;
    }
}

